/*
 * Created on Jul 8, 2003
 */
package Validators;

import Data.*;
import java.sql.*;

/**
 * This class is being used for validating time
 * 
 */
public class TimeValidator {

	private String message;
	/**
	 * This method is being used to get the validation message
	 * @return String message
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used setting validation message
	 * @param String message 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used to validate time
	 * @param announcementData data to be validated
	 * @return boolean true if validation successful
	 */
	public boolean validate(UserData userData) {

		UserData userdata = userData;
		Timestamp outFrom, outTo;

		outFrom = userdata.getOutFrom();
		outTo = userdata.getOutTo();
		long currentTime = System.currentTimeMillis();
		Timestamp time = new Timestamp(currentTime);
		time.setSeconds(0);

		if (outFrom.equals("") || outTo.equals("")) {
			message = "Please enter time values ";
			return false;
		}

		if (outFrom.before(time)) {
			message = "Time chosen is before the current time.";
			return false;
		}
		if (outTo.before(time)) {
			message = "Time chosen is before current time";
			return false;
		}

		return true;
	}
}
